import Mesher
import math
import trueSpace

ures = 192 # Number of sections along path
vres = 15 # number of points around cross-section
radius = 0.3 # radius of cross-section

points = []
faces = []

def trefoil(t):
	x = math.sin(t) + 2*math.sin(2*t)
	y = math.cos(t) - 2*math.cos(2*t)
	z = math.sin(3*t)
	return [x, y, z]
	
def dtrefoil(t):
	x = math.cos(t) + 4*math.cos(2*t)
	y = -math.sin(5) + 4*math.sin(2*t)
	z = 3*math.cos(3*t)
	return [x, y, z]

def norm(v):
	length = math.sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2])
	if length != 0:
		return [v[0]/length, v[1]/length, v[2]/length]
	else:
		return [v[0], v[1], v[2]]

def cross(v1, v2):
	x = v1[1]*v2[2] - v1[2]*v2[1]
	y = v1[2]*v2[0] - v1[0]*v2[2]
	z = v1[0]*v2[1] - v1[1]*v2[0]
	return [x, y, z]

def make_cross_section(t):
	points = []
	
	a = trefoil(t)
	b = norm(dtrefoil(t))
	c = norm([1 - (b[0]*b[0]), -(b[0]*b[1]), -(b[0]*b[2])])	
	d = norm(cross(b, c))
	
	for i in range(0, vres):
		xp = a[0] + radius*(math.cos(i*2*math.pi/vres)*c[0] + math.sin(i*2*math.pi/vres)*d[0])
		yp = a[1] + radius*(math.cos(i*2*math.pi/vres)*c[1] + math.sin(i*2*math.pi/vres)*d[1])
		zp = a[2] + radius*(math.cos(i*2*math.pi/vres)*c[2] + math.sin(i*2*math.pi/vres)*d[2])
		points.append([xp, yp, zp])

	return points
		
for t in range(0, ures):
	points[len(points):] = make_cross_section(t*2*math.pi/ures)

for u in range(0, ures):
	for v in range(0, vres):
		p1 = v + u*vres
		p2 = v + ((u+1)%ures)*vres
		p3 = (v+1)%vres + u*vres
		p4 = (v+1)%vres + ((u+1)%ures)*vres

		faces.append([[p1,v%2], [p2,v%2], [p4,v%2], [p3,v%2]])

uv = [[0.25, 0.25], [0.75, 0.75]]

Mesher.create(points, faces, uv)

trueSpace.Stop()
