import Mesher
import math

resolution = 50

pts = []
faces = []

def surface(x, y):
	return math.sin(x/5.0) * math.cos(y/5.0)

def point(x, y):
	return x + y * resolution

for x in range(0, resolution):
	for y in range(0, resolution):
		z = x + y
		pts.append([x/5.0-5, y/5.0-5, surface(x, y)])

for x in range(0, resolution-1):
	for y in range(0, resolution-1):
		faces.append([point(x+1, y), point(x, y), point(x, y+1)])
		faces.append([point(x+1, y), point(x, y+1), point(x+1, y+1)])

Mesher.create(pts, faces)
